﻿///
/// ファイルをアーカイブボリュームファイルに圧縮する実装クラスのヘッダファイル。
/// Internal: 非公開ヘッダファイル。
///

#if       !defined(INCLUDED_SZ_ARCHIVE_FILE_UPDATER_IMPL)
#define            INCLUDED_SZ_ARCHIVE_FILE_UPDATER_IMPL

#if       !defined(INCLUDED_SZ_COMMON)
#include  <szCommon.hpp>
#endif // !defined(INCLUDED_SZ_COMMON)

#if       !defined(INCLUDED_SZ_FORWARD_DECLARATIONS)
#include  <szForwardDeclarations.hpp>
#endif // !defined(INCLUDED_SZ_FORWARD_DECLARATIONS)

#include  <7zip/UI/Common/Update.h>

SZ_NS_BEG(szpp)

/// <summary>
/// ファイルをアーカイブに圧縮する簡単な圧縮処理を実現するための実装クラス。
/// </summary>
/// <notes>
/// クライアントが 7-Zip ヘッダを参照しなくて良いように、実装詳細は完全にこのクラスに分離してある。
/// </notes>
class SZ_SPEC ArchiveFileUpdaterImpl :
  public IOpenCallbackUI,
  public IUpdateCallbackUI2
{
public:

  ArchiveFileUpdaterImpl(
    ArchiveOpenClientCallback *openCallback,
    ArchiveFileUpdateClientCallback *updCallback,
    GetPasswordClientCallback *pwdCallback);
  ~ArchiveFileUpdaterImpl();

#pragma region 7-Zip インターフェース実装

  // IOpenCallbackUI
#ifndef _NO_CRYPTO
  virtual HRESULT Open_CryptoGetTextPassword(BSTR *password);
  virtual HRESULT Open_GetPasswordIfAny(UString &password);
  virtual bool Open_WasPasswordAsked();
  virtual void Open_ClearPasswordWasAskedFlag();
#endif
  virtual HRESULT Open_CheckBreak();
  virtual HRESULT Open_SetTotal(const UInt64 *files, const UInt64 *bytes);
  virtual HRESULT Open_SetCompleted(const UInt64 *files, const UInt64 *bytes);

  // IUpdateCallbackUI
  virtual HRESULT SetTotal(UInt64 size);
  virtual HRESULT SetCompleted(const UInt64 *completeValue);
  virtual HRESULT SetRatioInfo(const UInt64 *inSize, const UInt64 *outSize);
  virtual HRESULT CheckBreak();
  virtual HRESULT Finilize();
  virtual HRESULT SetNumFiles(UInt64 numFiles);
  virtual HRESULT GetStream(const wchar_t *name, bool isAnti);
  virtual HRESULT OpenFileError(const wchar_t *name, DWORD systemError);
  virtual HRESULT SetOperationResult(Int32 operationResult);
  virtual HRESULT CryptoGetTextPassword2(Int32 *passwordIsDefined, BSTR *password);
  virtual HRESULT CryptoGetTextPassword(BSTR *password);

  // IUpdateCallbackUI2
  virtual HRESULT OpenResult(const wchar_t *name, HRESULT result);
  virtual HRESULT StartScanning();
  virtual HRESULT ScanProgress(UInt64 numFolders, UInt64 numFiles, const wchar_t *path);
  virtual HRESULT CanNotFindError(const wchar_t *name, DWORD systemError);
  virtual HRESULT FinishScanning();
  virtual HRESULT StartArchive(const wchar_t *name, bool updating);
  virtual HRESULT FinishArchive();

#pragma endregion

#ifndef _NO_CRYPTO
  void SetInitialPassword(const szstring &password);
#endif

private:

#ifndef _NO_CRYPTO
  bool openPwdDefined;
  bool openPwdAsked;
  szstring openPwd;

  bool updPwdDefined;
  szstring updPwd;
#endif

  ArchiveOpenClientCallback       *openCallback;
  ArchiveFileUpdateClientCallback *updCallback;
  GetPasswordClientCallback       *pwdCallback;
};

SZ_NS_END(szpp)

#endif // !defined(INCLUDED_SZ_ARCHIVE_FILE_EXTRACTOR_IMPL)
